TITLE   'Metal and Dielectric Rod in a Parallel Field'          { exa114.pde }
SELECT     						{ Professional Edition }
   errlim=1e-7     ngrid=1     spectral_colors	
VARIABLES   U
DEFINITIONS						
   r0=0.04     d0=0.045     L=1.0	
   eps0=8.854e-12     epsr     eps=epsr*eps0
   Ex0=1e5     Dx0=eps0*Ex0      			{ Far Field }        	
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   D=eps*E     Dm=magnitude(D)
   F1=line_integral( -0.5*normal(D)*Ex, 'rod1')	{ Force on metal rod } 	
   fs=0.5*(eps-eps0)*[ tangential(E)^2+normal(E)^2*epsr]	{ Force/area }
   unit_x=vector(1,0)					{ Direction of x }
   f=fs*normal( unit_x)			{ Force/area, x-component }
   F2=surf_integral( f, 'rod2')		{ Integrated force, x-component }
EQUATIONS
   div( D)=0	         				{ div( eps*( -grad( U)))=0 }
BOUNDARIES
region 'domain'   epsr=1        			{ Vacuum }
   start(-L,-L)  natural(U)=0  line to (0,-L)  to (L,-L)
   natural(U)=Dx0  line to (L,L)
   natural(U)=0  line to (-L,L)
   natural(U)=-Dx0  line to close	
   start 'rod1' (-d0-r0,0)  value(U)=0 		{ Exclude for metal rod }
   arc( center=-d0,0) angle=360			
region 'glass'  epsr=7.0   start 'rod2' (d0+r0,0)
   arc( center=d0,0) to (d0,r0) to (d0-r0,0) to (d0,-r0) close
PLOTS
   grid( x, y) zoom(-5*d0,- 5*d0,  10*d0,10*d0)
   contour( Dm) zoom(-2.5*d0,-2.5*d0,  5*d0,5*d0)
   vector( D) norm zoom(-2.5*d0,-2.5*d0,  5*d0,5*d0)
      report( F1) as 'F1 on metal' report( F2) report((F1+F2)/F1)
END


